---
--- Created by jinjing.
--- DateTime: 2020/7/23 17:41
---

ImportScript("ugc_common/script/net/networking.lua")

---@class LNetProtoHandler
LNetProtoHandler = LNetProtoHandler or class("LNetProtoHandler");

function LNetProtoHandler:ctor()
    self.m_handlerFunc = {};
    self:RegisterFunc();
end

function LNetProtoHandler:dtor()
    self.m_handlerFunc = {};
end

-----------------
--עЭص
-----------------
function LNetProtoHandler:RegisterFunc()
    self.m_handlerFunc[protocol.MT.AUTHENTICATOR_LOGIN_AUTH_RESP] = self.onRecvLoginAuthResp;
    self.m_handlerFunc[protocol.MT.DISPATCHER_LOGIN_GAME_RESP] = self.onRecvLoginGameResp;
    self.m_handlerFunc[protocol.MT.GS_SYNC_NEAR_ENTITY_ENTER] = self.onSyncNearEntityEnter;
    self.m_handlerFunc[protocol.MT.GS_SYNC_NEAR_ENTITY_LEAVE] = self.onSyncNearEntityLeave;
    self.m_handlerFunc[protocol.MT.GS_SYNC_ENTITY_POS] = self.onSyncEntityPos;
    self.m_handlerFunc[protocol.MT.GS_SYNC_NEAR_ENTITIES_ENTER] = self.onSyncNearEntitiesEnter;
    self.m_handlerFunc[protocol.MT.GS_SYNC_NEAR_ENTITIES_LEAVE] = self.onSyncNearEntitiesLeave;
    self.m_handlerFunc[protocol.MT.GS_SYNC_INPUT_STATE] = self.onSyncInputState;
    self.m_handlerFunc[protocol.MT.GS_SYNC_CHAT_MSG] = self.onSyncChatMsg;
    self.m_handlerFunc[protocol.MT.GS_CREATE_ENTITY_RESPONSE] = self.onCreateEntityReponse;
end

function LNetProtoHandler:MsgProc(msgType, msgData)
    --LOG_I("[LNetProtoHandler:MsgProc] ", msgType, string.len(msgData));

    local func = self.m_handlerFunc[msgType];
    if not func then
        LOG_E("LNetProtoHandler:MsgProc func not found: ", msgType);
        return;
    end

    func(self, msgData);
end

--֤½
function LNetProtoHandler:onRecvLoginAuthResp(msgData)
    local ret = false;

    LOG_I("[onRecvLoginAuthResp] ", string.len(msgData));
    local data = proto.decode("protocol.A2C_LoginAuthResp", msgData)
    LOG_I("receive auth info: ", data.accessKey, data.secretKey, data.gateAddr)

    g_NetWorking:cb_LoginAuthSuccess();
    g_NetWorking:DisConnect(g_NetWorking.SERVER_AUTH);

    local index = string.find(data.gateAddr, ":");
    local ip = string.sub(data.gateAddr,1, index-1);
    local port = string.sub(data.gateAddr, index+1, string.len(data.gateAddr));
    ret = g_NetWorking:Connect(g_NetWorking.SERVER_GS, ip, tonumber(port));
    if not ret then
        LOG_E("LNetProtoHandler:onRecvLoginAuthResp conn fail: ", ip, port);
        return;
    end

    g_NetWorking:LoginGS(data.accessKey, data.secretKey);
end

--GS½
function LNetProtoHandler:onRecvLoginGameResp(msgData)
    --LOG_I("[onRecvLoginGameResp] ", string.len(msgData));
    local data = proto.decode("protocol.GsPlayerLoginResp", msgData)
    LOG_I("receive LoginGameResp: ", data.mapId, data.entityId)

    g_NetWorking:cb_LoginGSSuccess(data.mapId, data.entityId);
end

--ͬentity
function LNetProtoHandler:onSyncNearEntityEnter(msgData)
    print("onSyncNearEntityEnter>>>>>>>>");
    local data = proto.decode("protocol.Gs2C_NearEntityEnter", msgData)
    LOG_I("receive EntityEnter: ", string.len(msgData))

    g_NetWorking:cb_CreateNewEntity(data);
end

--ͬ뿪entity
function LNetProtoHandler:onSyncNearEntityLeave(msgData)
    print("onSyncNearEntityLeave>>>>>>>>");
    local data = proto.decode("protocol.Gs2C_NearEntityLeave", msgData)
    LOG_I("receive EntityLeave: ", data.entityId)

    g_NetWorking:cb_DeleteEntity(data.entityId);
end

--ͬentityλϢ
function LNetProtoHandler:onSyncEntityPos(msgData)
    local data = proto.decode("protocol.Gs2C_SyncEntityPos", msgData)
    --LOG_I("receive EntityPos: ", data.entityId, data.pos.x, data.pos.y, data.pos.z, data.pos.w )

    g_NetWorking:cb_SyncEntityPos(data.entityId, data.pos);
end

--ͬentityб
function LNetProtoHandler:onSyncNearEntitiesEnter(msgData)
    print("onSyncNearEntitiesEnter>>>>>>>>");
    local data = proto.decode("protocol.Gs2C_NearEntitiesEnter", msgData)

    for id, entity in pairs (data.entities) do
        print("new entity id >>>>>>>>>>>>>>>> : " .. id);
        util.printTB(entity);
        g_NetWorking:cb_CreateNewEntity(entity);
    end
end

--ͬ뿪entityб
function LNetProtoHandler:onSyncNearEntitiesLeave(msgData)
    print("onSyncNearEntitiesLeave>>>>>>>>");
    local data = proto.decode("protocol.Gs2C_NearEntityLeave", msgData)
    LOG_I("receive onSyncNearEntitiesLeave: ", unpack(data))

    for _, entity in pairs (data.entityIds) do
        g_NetWorking:cb_DeleteEntity(entity.entityId);
    end
end

--ͬentity״̬
function LNetProtoHandler:onSyncInputState(msgData)
    local data = proto.decode("protocol.Gs2C_SyncEntityInputState", msgData)
    LOG_I("receive onSyncInputState: ", data.entityId, data.state)

    g_NetWorking:cb_EntityChangeState(data.entityId, data.state);
end

--Ϣ
function LNetProtoHandler:onSyncChatMsg(msgData)
    --LOG_I("[onSyncChatMsg] ", string.len(msgData));
    local data = proto.decode("protocol.GS2C_SendChatMsg", msgData)
    LOG_I("receive chatmsg: ", data.chatType, data.chatSender, data.chatContent)

    g_NetWorking:cb_onRecvChatMsg(data.chatType, data.chatSender, data.chatContent);
end

function LNetProtoHandler:onCreateEntityReponse(msgData)
    local data = proto.decode("protocol.Gs2C_CreateEntityResp", msgData)
    LOG_I("receive create entity resp: ", data.entityId, data.clientEntityId)

    g_NetWorking:cb_CreateEntityResp(data.entityId, data.clientEntityId);
end

_G.g_NetProtoHandler = LNetProtoHandler:new();
