---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by HUAFEI2.
--- DateTime: 2020/6/11 14:42
---

local LBaseActor = ImportScript("ugc_common/script/core/actor/actor.lua").LBaseActor;

---@class LActor
LActor = LActor or class("LActor", LBaseActor);

---@param kActor AActor
function LActor:ctor(kActor)
    self.m_kActor = tolua.cast(kActor, "Core::AActor")
    LOG_I("LActor:ctor", self, kActor, self.m_kActor)
    self.m_name = self:ToString();
    self.m_id = self.m_kActor:GetId();
end

function LActor:dtor()
    print("LActor:dtor()", self.m_name, self.m_kActor);
    self.m_id = nil;
end

---@return KActor
function LActor:GetKActor()
    return self.m_kActor;
end

---@return Core::FAttributeSet
function LActor:GetAttributeSet()
    return self.m_kActor:GetAttributeObj(true);
end

---@return number
function LActor:GetId()
    if self.m_kActor ~= nil then
        return self.m_kActor:GetId();
    end
    return 0;
end

---@return string
function LActor:GetType()
    return "LActor";
end

---@return boolean
function LActor:IsValid()
    return KLActorManager.IsValidActor(self.m_id);
end

---@return number fZ
function LActor:GetWorldTransform()
    if not self:IsValid() then
        return false;
    end
    return true, self.m_kActor:GetWorldTransform();
end

---@param fX number
---@param fY number
---@param fZ number
---@param bTeleport boolean @default value:false 
---@return boolean
function LActor:SetWorldPosition(fX, fY, fZ, bTeleport)
    self.m_kActor:SetWorldPosition(fX, fY, fZ, bTeleport or false);
    return true;
end

---@return boolean
---@return number fX
---@return number fY
---@return number fZ
function LActor:GetWorldPosition()
    --print("LActor:GetWorldPosition: ", self.m_name, self.m_kActor, self.m_kActor.GetId)
    if not self:IsValid() then
        return false;
    end
    return true, self.m_kActor:GetWorldPosition(0, 0, 0);
end

---@param fPitch number
---@param fYaw number
---@param fRoll number
---@return boolean
function LActor:SetWorldRotation(fPitch, fYaw, fRoll, bTeleport)
    --LOG_I("LActor:SetWorldRotation: ", fPitch, fYaw, fRoll)
    self.m_kActor:SetWorldRotation(fPitch, fYaw, fRoll, bTeleport or false);
    return true;
end

---@return boolean
---@return number fPitch
---@return number fYaw
---@return number fRoll
function LActor:GetWorldRotation()
    if not self:IsValid() then
        return false;
    end
    return true, self.m_kActor:GetWorldRotation(0, 0, 0);
end

---@param fX number
---@param fY number
---@param fZ number
---@return boolean
function LActor:SetWorldScale(fX, fY, fZ)
    self.m_kActor:SetWorldScale(fX, fY, fZ);
    return true;
end

---@return boolean
---@return number fX
---@return number fY
---@return number fZ
function LActor:GetWorldScale()
    if not self:IsValid() then
        return false;
    end
    return true, self.m_kActor:GetWorldScale(0, 0, 0);
end

---@param fX number
---@param fY number
---@param fZ number
---@param bTeleport boolean @default value:false 
---@return boolean
function LActor:SetLocalPosition(fX, fY, fZ, bTeleport)
    self.m_kActor:SetLocalPosition(fX, fY, fZ, bTeleport);
    return true;
end

---@return boolean
---@return number fX
---@return number fY
---@return number fZ
function LActor:GetLocalPosition()
    if not self:IsValid() then
        return false;
    end
    return true, self.m_kActor:GetLocalPosition(0, 0, 0);
end

---@param fPitch number
---@param fYaw number
---@param fRoll number
---@return boolean
function LActor:SetLocalRotation(fPitch, fYaw, fRoll)
    self.m_kActor:SetLocalRotation(fPitch, fYaw, fRoll)
    return true;
end

---@return boolean
---@return number fPitch
---@return number fYaw
---@return number fRoll
function LActor:GetLocalRotation()
    if not self:IsValid() then
        return false;
    end
    return true, self.m_kActor:GetLocalRotation(0, 0, 0);
end

---@param fX number
---@param fY number
---@param fZ number
---@return boolean
function LActor:SetLocalScale(fX, fY, fZ)
    self.m_kActor:SetLocalScale(fX, fY, fZ)
    return true;
end

---@return boolean
---@return number fX
---@return number fY
---@return number fZ
function LActor:GetLocalScale()
    if not self:IsValid() then
        return false;
    end
    return true, self.m_kActor:GetLocalScale(0, 0, 0);
end

---@return KTransform
function LActor:GetReviseTransform()
    return self.m_kActor:GetReviseTransform();
end

---@return KVec3
function LActor:GetFaceDirection()
    return self.m_kActor:GetFaceDirection();
end

---@param dir KVec3
function LActor:SetFaceDirection(dir)
    self.m_kActor:SetFaceDirection(dir);
end

---@param bVisible boolean
---@return boolean
function LActor:SetVisible(bVisible)
    if bVisible == nil then
        return
    end
    return self.m_kActor:SetVisible(bVisible);
end

---@return boolean
function LActor:IsVisible()
    return self.m_kActor:IsVisible();
end

-----------------------------------------ATTACHMENT ABOUT-----------------------------------------

---@return boolean
function LActor:IsUsingAbsolutePosition()
    return self.m_kActor:IsUsingAbsolutePosition();
end

---@return boolean
function LActor:IsUsingAbsoluteRotation()
    return self.m_kActor:IsUsingAbsoluteRotation();
end

---@return boolean
function LActor:IsUsingAbsoluteScale()
    return self.m_kActor:IsUsingAbsoluteScale();
end

---@param bAbsolutePosition boolean
---@param bAbsoluteRotation boolean
---@param bAbsoluteScale boolean
---@return boolean
function LActor:SetAbsolute(bAbsolutePosition, bAbsoluteRotation, bAbsoluteScale)
    return self.m_kActor:SetAbsolute(bAbsolutePosition, bAbsoluteRotation, bAbsoluteScale);
end

---@return LBaseActor
function LActor:GetAttachParent()
    local kActor = self.m_kActor:GetAttachParent();
    if kActor == nil then
        return nil;
    end
    local actorId = kActor:GetId();
    return g_ActorManager:GetActorById(actorId);
end

---@param lActor LBaseActor
---@param szBoneName string
---@param eAttachRule number
---@return boolean
function LActor:AttachToBone(lActor, szBoneName, eAttachRule)
    local kActor = lActor:GetKActor();
    if kActor == nil then
        return false;
    end
    return self.m_kActor:AttachToBone(kActor, szBoneName, eAttachRule);
end

---@param lActor LBaseActor
---@param szSocketName string
---@param eAttachRule number
---@return boolean
function LActor:AttachToSocket(lActor, szSocketName, eAttachRule)
    local kActor = lActor:GetKActor();
    if kActor == nil then
        return false;
    end
    return self.m_kActor:AttachToSocket(kActor, szSocketName, eAttachRule);
end

---@param lActor LBaseActor
---@param szAnchorPointName string
---@param eAttachRule number
---@return boolean
function LActor:AttachToAnchorPoint(lActor, szAnchorPointName, eAttachRule)
    local kActor = lActor:GetKActor();
    if kActor == nil then
        return false;
    end
    return self.m_kActor:AttachToAnchorPoint(kActor, szAnchorPointName, eAttachRule);
end

---@param lActor LBaseActor
---@param eAttachRule number
---@return boolean
function LActor:AttachToParent(lActor, eAttachRule)
    local kActor = lActor:GetKActor();
    LOG_I("[LActor:AttachToParent] ", kActor, lActor.m_kActor, eAttachRule or Core.eAR_SnapToTarget);
    if kActor == nil then
        return false;
    end
    return self.m_kActor:AttachToParent(kActor, eAttachRule or Core.eAR_SnapToTarget);
end

---@return boolean
function LActor:DetachFromParent()
    return self.m_kActor:DetachFromParent();
end

-----------------------------------------PHYSICS ABOUT-----------------------------------------
---@return ECollisionType
function LActor:GetCollisionType()
    local bodyInst = self.m_kActor:GetBodyInstance();
    if bodyInst ~= nil then
        return bodyInst:GetCollisionType();
    end
    return nil;
end

---@param eType ECollisionType
---@return boolean
function LActor:SetCollisionType(eType)
    local bodyInst = self.m_kActor:GetBodyInstance();
    if bodyInst ~= nil then
        bodyInst:SetCollisionType(eType);
        return true;
    end
    return false;
end

---@param eType bSimulate
---@return boolean
function LActor:SetSimulatePhysics(bSimulate)
    local bodyInst = self.m_kActor:GetBodyInstance();
    if bodyInst ~= nil then
        bodyInst:SetSimulatePhysics(bSimulate);
        return true;
    end
    return false;
end

---@return boolean
function LActor:IsSimulatePhysics()
    local bodyInst = self.m_kActor:GetBodyInstance();
    if bodyInst ~= nil then
        return bodyInst:IsSimulatePhysics();
    end
    return false;
end

---@param bStatic bool
---@return boolean
function LActor:SetPhysicsStatic(bStatic)
    local bodyInst = self.m_kActor:GetBodyInstance();
    if bodyInst ~= nil then
        bodyInst:SetStatic(bStatic);
        return true;
    end
    return false;
end

---@param x float
---@param y float
---@param z float
---@param bAddToCurrent bool
---@return boolean
function LActor:SetLinearVelocity(x, y, z, bAddToCurrent)
    x = x or 0.0;
    y = z or 0.0;
    z = z or 0.0;
    bAddToCurrent = bAddToCurrent or false;
    local bodyInst = self.m_kActor:GetBodyInstance();
    if bodyInst ~= nil then
        bodyInst:SetLinearVelocity(x, y, z, bAddToCurrent);
        return true;
    end
    return false;
end

---@param szJsonRes string
---@return boolean
function LActor:SetCollisionGeometry(szJsonRes)
    local bodyInst = self.m_kActor:GetBodyInstance();
    if bodyInst ~= nil then
        return bodyInst:SetCollisionGeometry(szJsonRes);
    end
    return false;
end

---@param fMaxStepHeight float
---@return boolean
function LActor:SetMaxStepHeight(fMaxStepHeight)
    local bodyInst = self.m_kActor:GetBodyInstance();
    if bodyInst ~= nil then
        return bodyInst:SetMaxStepHeight(fMaxStepHeight);
    end
    return false;
end
-----------------------------------------OTHERS ABOUT-----------------------------------------

_G.LActor = LActor;
