-----------------------------------------------------------------------------
--űļphysics_constraint_actor_impl.lua
--ƣ
--ܿpage(pk)
--ʱ䣺2020/07/13 16:39:26
--űܣԼpc߼
--޸ļ¼
-----------------------------------------------------------------------------

local LBasePhysicsConstraintActor = ImportScript("ugc_common/script/core/actor/physics_constraint_actor.lua").LBasePhysicsConstraintActor;
local LActor = ImportScript("ugc_common/script/pc/actor/actor_impl.lua").LActor;

---@class LPhysicsConstraintActor
LPhysicsConstraintActor = LPhysicsConstraintActor or class("LPhysicsConstraintActor", LBasePhysicsConstraintActor, LActor);

function LPhysicsConstraintActor:ctor(kActor)
    self.m_kPhysicsConstraintActor = tolua.cast(kActor, "Core::APhysicsConstraintActor")
    LOG_I("LPhysicsConstraintActor:ctor", self, kActor, self.m_name, self.m_kPhysicsConstraintActor)
end

function LPhysicsConstraintActor:dtor()
    print("LPhysicsConstraintActor:dtor()");
end

---@param eType ELinearConstraintMotion
---@return boolean
function LPhysicsConstraintActor:SetLinearXMotion(eType)
    local inst = self.m_kPhysicsConstraintActor:GetConstraintInstance();
    if inst ~= nil then
        inst:SetLinearXMotion(eType);
        return true;
    end
    return false;
end

---@param eType ELinearConstraintMotion
---@return boolean
function LPhysicsConstraintActor:SetLinearYMotion(eType)
    local inst = self.m_kPhysicsConstraintActor:GetConstraintInstance();
    if inst ~= nil then
        inst:SetLinearYMotion(eType);
        return true;
    end
    return false;
end

---@param eType ELinearConstraintMotion
---@return boolean
function LPhysicsConstraintActor:SetLinearZMotion(eType)
    local inst = self.m_kPhysicsConstraintActor:GetConstraintInstance();
    if inst ~= nil then
        inst:SetLinearZMotion(eType);
        return true;
    end
    return false;
end

---@param fLinearLimit float
---@param fContactDistance float
---@param fRestitution float
---@return boolean
function LPhysicsConstraintActor:SetLinearLimit(fLinearLimit, fContactDistance, fRestitution)
    fLinearLimit = fLinearLimit or 0.0;
    fContactDistance = fContactDistance or 0.0;
    fRestitution = fRestitution or 0.0;

    local inst = self.m_kPhysicsConstraintActor:GetConstraintInstance();
    if inst ~= nil then
        inst:SetLinearLimit(fLinearLimit, fContactDistance, fRestitution);
        return true;
    end
    return false;
end

---@param eType ELinearConstraintMotion
---@return boolean
function LPhysicsConstraintActor:SetAngularTwistMotion(eType)
    local inst = self.m_kPhysicsConstraintActor:GetConstraintInstance();
    if inst ~= nil then
        inst:SetAngularTwistMotion(eType);
        return true;
    end
    return false;
end

---@param eType ELinearConstraintMotion
---@return boolean
function LPhysicsConstraintActor:SetAngularSwing1Motion(eType)
    local inst = self.m_kPhysicsConstraintActor:GetConstraintInstance();
    if inst ~= nil then
        inst:SetAngularSwing1Motion(eType);
        return true;
    end
    return false;
end

---@param eType ELinearConstraintMotion
---@return boolean
function LPhysicsConstraintActor:SetAngularSwing2Motion(eType)
    local inst = self.m_kPhysicsConstraintActor:GetConstraintInstance();
    if inst ~= nil then
        inst:SetAngularSwing2Motion(eType);
        return true;
    end
    return false;
end

---@param fSwing1LimitAngle float
---@return boolean
function LPhysicsConstraintActor:SetAngularSwing1Limit(fSwing1LimitAngle)
    fSwing1LimitAngle = fSwing1LimitAngle or 0.0;

    local inst = self.m_kPhysicsConstraintActor:GetConstraintInstance();
    if inst ~= nil then
        inst:SetAngularSwing1Limit(fSwing1LimitAngle);
        return true;
    end
    return false;
end

---@param fSwing2LimitAngle float
---@return boolean
function LPhysicsConstraintActor:SetAngularSwing2Limit(fSwing2LimitAngle)
    fSwing2LimitAngle = fSwing2LimitAngle or 0.0;

    local inst = self.m_kPhysicsConstraintActor:GetConstraintInstance();
    if inst ~= nil then
        inst:SetAngularSwing2Limit(fSwing2LimitAngle);
        return true;
    end
    return false;
end

---@param fTwistLimitAngle float
---@param fContactDistance float
---@param fRestitution float
---@return boolean
function LPhysicsConstraintActor:SetAngularTwistLimit(fTwistLimitAngle)
    fTwistLimitAngle = fTwistLimitAngle or 0.0;
    local inst = self.m_kPhysicsConstraintActor:GetConstraintInstance();
    if inst ~= nil then
        inst:SetAngularTwistLimit(fTwistLimitAngle);
        return true;
    end
    return false;
end

---@param fForce float
---@param fTorque float
---@return boolean
function LPhysicsConstraintActor:SetBreakForce(fForce, fTorque)
    fForce = fForce or 0.0;
    fTorque = fTorque or 0.0;

    local inst = self.m_kPhysicsConstraintActor:GetConstraintInstance();
    if inst ~= nil then
        inst:SetBreakForce(fForce, fTorque);
        return true;
    end
    return false;
end