---
--- Date         : 2020-07-16 11:49:36
--- Author       : HUAFEI
--- LastEditors  : LICHAO7
--- LastEditTime : 2020-08-14 15:59:30
--- Description  : Simple flight actor
---
local LBaseSimpleFightActor = ImportScript("ugc_common/script/core/actor/simple_flight_actor.lua").LBaseSimpleFightActor;
local LSkeletalMeshActor = ImportScript("ugc_common/script/pc/actor/skeletal_mesh_actor_impl.lua").LSkeletalMeshActor;

---@class LSimpleFightActor
LSimpleFightActor = LWheeledVehicleActor or class("LSimpleFightActor", LBaseSimpleFightActor, LSkeletalMeshActor);

function LSimpleFightActor:ctor(kActor)
    self.m_kSimpleFlightActor = tolua.cast(kActor, "Core::ASimpleFlightActor")
    LOG_I("LSimpleFightActor:ctor", self, kActor, self.m_name, self.m_kSimpleFlightActor)
end

function LSimpleFightActor:dtor()
    print("LSimpleFightActor:dtor()");
end

---@return boolean
function LSimpleFightActor:BeginControl()
    return self.m_kSimpleFlightActor:BeginControl();
end

---@return boolean
function LSimpleFightActor:EndControl()
    return self.m_kSimpleFlightActor:EndControl();
end

---
--- Set flight component asset.
---
--- @param strAsset string
--- @param nCompKey number
--- @return boolean
---
function LSimpleFightActor:SetupComponent(strAsset, nCompKey)
    return self.m_kSimpleFlightActor:SetMeshRes(strAsset);
end