---
--- Date         : 2020-08-11 15:59:20
--- Author       : LICHAO7
--- LastEditors  : LICHAO7
--- LastEditTime : 2020-08-18 17:39:10
--- Description  : Assemble factory.
---

local LSimpleFlightAssemble   = ReLoadScript("ugc_common/script/pc/assemble/simple_flight_assemble.lua").LSimpleFlightAssemble;
local LWheeledVehicleAssemble = ReLoadScript("ugc_common/script/pc/assemble/wheeled_vehicle_assemble.lua").LWheeledVehicleAssemble;
local LComponentAssemble      = ReLoadScript("ugc_common/script/pc/assemble/component_assemble.lua").LComponentAssemble;

---
--- עAssemble
--- @type table
---
LAssembleRegistered     = {
    LSimpleFlightAssemble   = LSimpleFlightAssemble,
    LWheeledVehicleAssemble = LWheeledVehicleAssemble,
    LComponentAssemble      = LComponentAssemble,
};

---
--- Assemble factory function.
---
--- @param assemble_fp string
--- @param asType LBaseAssemble
--- @return LBaseAssemble | nil
---
LAssembleFactory = function(assemble_fp, asType)
    local aFile = nil;
    local class = assemble_fp;
    local initf = false;
    if FS.Path.Exists(assemble_fp) then
        aFile = JSON.Loadf(assemble_fp, { Type = nil });
        class = aFile.Type;
        initf = true;
    end
    class = LAssembleRegistered[class];
    if asType and asType ~= class then
        class = nil;
    end
    if type(class) == "table" then
        class = class:new();
        if initf then
            class:InitFromFile(assemble_fp);
        end
    end
    aFile = nil;
    return class;
end

---
--- Assemble factory function.
---
--- @param assemble_fp string
--- @return LBaseAssemble | nil
---
LAssembleTypeOf = function(assemble_fp)
    local aFile = nil;
    local class = assemble_fp;
    if FS.Path.Exists(assemble_fp) then
        aFile = JSON.Loadf(assemble_fp, { Type = nil });
        class = aFile.Type;
    end
    aFile = nil;
    return class;
end