---
--- Date         : 2020-07-22 11:24:16
--- Author       : LICHAO7
--- LastEditors  : LICHAO7
--- LastEditTime : 2020-08-05 10:15:42
--- Description  : FS Test Code
---

local TestPaths = {
    cwd        = "I:\\sword3-products\\trunk\\EditorTool\\MiniClient",
    existsPath = "\\ugc_common\\script\\test\\run.lua",
    walk       = "I:\\sword3-products\\trunk\\EditorTool\\MiniClient\\ugc_common\\script",
    newFile    = "I:\\sword3-products\\trunk\\EditorTool\\MiniClient\\ugc_common\\script\\test\\TestFile.txt"
};

local FailedMsg = function(modulename)
    return modulename .. ": Failed.";
end

function Test()
    assert(FS.Path.Exists(TestPaths.cwd), FailedMsg("FS.Path.Exists"));
    assert(FS.Path.Join(TestPaths.cwd, TestPaths.existsPath) == TestPaths.cwd .. TestPaths.existsPath, FailedMsg("FS.Path.Join"));
    assert(FS.Path.IsDir(TestPaths.cwd), FailedMsg("FS.Path.IsDir"));
    assert(FS.Path.IsFile(FS.Path.Join(TestPaths.cwd, TestPaths.existsPath)), FailedMsg("FS.Path.IsFile"));
    assert(FS.Path.IsLink(FS.Path.Join(TestPaths.cwd, TestPaths.existsPath)) == false, FailedMsg("FS.Path.IsLink"));
    assert(FS.Path.SEP == "\\", FailedMsg("FS.Path.SEP"));

    -- path split test
    assert(FS.Path.Split(TestPaths.cwd)[1] == "I:", FailedMsg("FS.Path.Split"));
    assert(FS.Path.SplitDir(TestPaths.existsPath) == "ugc_common\\script\\test", FailedMsg("FS.Path.Split"));
    assert(FS.Path.SplitExt(TestPaths.existsPath) == ".lua", FailedMsg("FS.Path.SplitExt"));
    assert(FS.Path.SplitFile(TestPaths.existsPath) == "run.lua", FailedMsg("FS.Path.SplitFile"));

    -- walk folder test
    local WalkCB = function (current, dirs, files)
        for key, value in pairs(dirs) do
            print("Dir:", FS.Path.Join(current, value));
        end
        for key, value in pairs(files) do
            print("File:", FS.Path.Join(current, value));
        end
    end
    FS.Walk(TestPaths.walk, WalkCB);

    -- file io
    local file = FS.Open(TestPaths.newFile, "w+");
    file.Write("line1\n");
    file.Write("line2\n");
    file.Write("line3\n");
    print("File seek pos:", file.Seek());
    print("File size:", file.Size());
    assert(file.Valid(), FailedMsg("File.Valid"));
    file.Close();
    file = FS.Open(TestPaths.newFile, "r");
    print("File Content:", file.Read());

    local dirs = FS.Path.Join(TestPaths.walk, "test1", "jdsahdj");
    assert(FS.MakeDirs(dirs), FailedMsg("FS.MakeDirs"));
    assert(FS.RemoveAll(FS.Path.Join(TestPaths.walk, "test1")), FailedMsg("FS.RemoveAll"));
end
