struct ShaderConstsLensflare
{
    float4x4     matRotation;
    float2       vSunPosPostProj;
    float2       vTexSplit;
    float        fScreenAspect;    //Width/Height    To adjust the sun shape
    float        fBlendFactor;
    float        fOCFactor;
#ifdef __cplusplus
    ShaderConstsLensflare()
    {
        memset(this, 0, sizeof(*this));
    }
#endif
};

sampler2D samp0 : register(s0);

ShaderConstsLensflare g_shaderConsts;

void vertexShaderFirst( in  float3 iVB       : POSITION0
                       ,in  half2  iTexCoord : TEXCOORD0
                       ,out float4 oPos      : POSITION0
                       ,out half2  oTexCoord : TEXCOORD0)
{
    float2 PosRet = iVB.xy;
    PosRet.y *= g_shaderConsts.fScreenAspect;
    float2 vTrans = g_shaderConsts.vSunPosPostProj * iVB.z;
    PosRet += vTrans;
    oPos = float4(PosRet, 0, 1);
    
    oTexCoord = g_shaderConsts.vTexSplit * iTexCoord;
}

float4 pixelShaderFirst(in float2 iTexCoord : TEXCOORD0) : COLOR
{
    float4 p0 = tex2D(samp0, iTexCoord);
    return float4(p0.rgb, g_shaderConsts.fBlendFactor * p0.a);
}

void vertexShaderOther( in  float3 iVB       : POSITION0
                       ,in  half2  iTexCoord : TEXCOORD0
                       ,out float4 oPos      : POSITION0
                       ,out half2  oTexCoord : TEXCOORD0)
{
    float3 PosRet = float3(iVB.xy, 1);
    PosRet = mul(PosRet, (float3x3)g_shaderConsts.matRotation);
    PosRet.y *= g_shaderConsts.fScreenAspect;
    float2 vTrans = g_shaderConsts.vSunPosPostProj * iVB.z;
    PosRet.xy += vTrans;
    oPos = float4(PosRet.xy, 0, 1);
    
    oTexCoord = g_shaderConsts.vTexSplit * iTexCoord;
}

float4 pixelShaderOther(in float2 iTexCoord : TEXCOORD0) : COLOR
{
    float4 p0 =  tex2D(samp0, iTexCoord);
    return float4(p0.rgb * g_shaderConsts.fBlendFactor, 0.0f);
}

void vertexShaderOC( in  float3 iVB  : POSITION0
                    ,out float4 oPos : POSITION0)
{
    float2 PosTemp = iVB.xy;
    PosTemp.y *= g_shaderConsts.fScreenAspect;
    oPos = float4(PosTemp + g_shaderConsts.vSunPosPostProj, 1, 1);
}

float4 pixelShaderOC() : COLOR
{
    return float4(0, 0, 0, g_shaderConsts.fOCFactor);
}

technique LensFlareFirst
{
    pass pFirst
    {
        VertexShader = compile vs_2_0 vertexShaderFirst();
        PixelShader  = compile ps_2_0 pixelShaderFirst();
        
        ZEnable = FALSE;
        FogEnable = FALSE;
        ZWriteEnable = FALSE;
        CullMode = CCW;        
        
        AlphaBlendEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
}

technique LensFlareOther
{
    pass pOther
    {
        VertexShader = compile vs_2_0 vertexShaderOther();
        PixelShader  = compile ps_2_0 pixelShaderOther();
        
        ZEnable = FALSE;
        FogEnable = FALSE;
        ZWriteEnable = FALSE;
        CullMode = CCW;        
        
        AlphaBlendEnable = TRUE;
        SrcBlend = One;
        DestBlend = One;
    }
}

technique LensFlareOC
{
    pass pOC
    {
        VertexShader = compile vs_2_0 vertexShaderOC();
        PixelShader  = compile ps_2_0 pixelShaderOC();
        
        ZEnable = TRUE;
        ZFunc = LessEqual;
        FogEnable = FALSE;
        ZWriteEnable = FALSE;
        CullMode = CCW;        
        
        AlphaBlendEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
}