//////////////////////////////////////////////////////////////
//Compute Light for LM_Lambert : diffuse+emissive+ambient
//////////////////////////////////////////////////////////////
#ifdef LM_LAMBERT
float3 computeLambert(
	float3 ambientColor,
	float3 emissiveColor,
	float3 diffuseColor,
	float3 N//worldNormal
#if defined(POINTLIGHT) || defined(COVERPOINTLIGHT)
	,float3 ScreenPos
#endif
#ifdef SHADOWMAP
	,float shadowMask
#endif
	)
{
	float3 color = emissiveColor;
	color += sunLight.m_sceneAmbient.rgb * diffuseColor;
	float L = normalize(-sunLight.m_dir);
	float diffuse = max(0,dot(N,L));
	float3 sunColor =  sunLight.m_diffuse.rgb  * diffuseColor * diffuse;
#ifdef SHADOWMAP
	sunColor  *= shadowMask;
#endif
	color += sunColor ;
#if defined(POINTLIGHT) || defined(COVERPOINTLIGHT)
	float3 LightColor = tex2D_PointLight(N,ScreenPos);
	color += LightColor * diffuseColor * diffuse;
#endif
	return color;
}
#endif
//////////////////////////////////////////////////////////////
//Compute Light for LM_Phong :  diffuse+emissive+ambient+specular
//////////////////////////////////////////////////////////////
#ifdef LM_PHONG
#define SPECULAR
float3 computePhong(
	float3 ambientColor,
	float3 emissiveColor,
	float3 diffuseColor,
	float3 specularColor,
	float specularPower,
	float3 N//worldNormal
#if defined(POINTLIGHT) || defined(COVERPOINTLIGHT)
	,float3 ScreenPos
#endif
	,float3 V
#ifdef SHADOWMAP
	,float shadowMask
#endif
	)
{
	float3 color =  emissiveColor;
	color += sunLight.m_sceneAmbient.rgb * diffuseColor;
	//calc sunlight diffuse and specular
	float3 L = normalize(-sunLight.m_dir);
	float diffuse = max(0,dot(N,L));
	color += sunLight.m_diffuse.rgb * diffuse * diffuseColor;
	//blinn_phong
	half3 H = normalize(V + L);
	float specular = min(diffuse*5,1) *pow(saturate(dot(N,H)),specularPower);
	float3 sunColor =  sunLight.m_specular.rgb  * specularColor * specular;
#ifdef SHADOWMAP
	sunColor  *= shadowMask;
#endif
	color += sunColor ;

#if defined(POINTLIGHT) || defined(COVERPOINTLIGHT)
	float3 LightColor = tex2D_PointLight(N,ScreenPos,L);
	color += LightColor * diffuseColor * diffuse;
	color += LightColor * specular * specularColor;
#endif
	return color;
}
#endif

/////////////////////////////////////////////////////////////////////////////
//Compute Light for LM_JX3 
/////////////////////////////////////////////////////////////////////////////
#ifdef LM_JX3

#ifdef SPECULAR
float computerSpecLight(float3 V,float3 N,float3 L,float shininess)
{
    V = normalize(V);
    N = normalize(N);
    L = normalize(L);

    float specularLight = 0;
    float3 Half_vector = normalize(L + V);
    float HdotN = max(0, dot(Half_vector,N));
    specularLight = pow(abs(HdotN), shininess) * 10;
    return specularLight;
}
#endif

#ifdef SSS 
float3 ComputeSSSLight(float3 L,float3 normal,float3 vEye,float sssRate,float3 color)
{
    float3 vLTLight = normalize(L + normal*0.6) ;
    float fLTDot = pow(dot(vEye,-vLTLight),20);
    return color * fLTDot * sssRate;
}
#endif

#if defined(POINTLIGHT) || defined(COVERPOINTLIGHT)
float3 CalPointLight(float3 normal,
			float3 pos,
			float4 screenPos,
			bool bPointLight
#ifdef SPECULAR
			,float3 specularColor,
			float speculatPower,
			float specularRate
#endif
#ifdef SSS
			,float SSSRate
#endif
					 )
{
    float3 ret = {0,0,0};
#if defined(POINTLIGHT) || defined(COVERPOINTLIGHT)
	float3 L={1,1,1};
	float3 N=normal;
    float3 LightColor = float3(0, 0, 0); 
	[branch]
	if (bPointLight)
	{
	   LightColor = tex2D_PointLight(N,screenPos);              //老材质的点光源*0.35, 和这里不一样
	}
	ret += LightColor;//max(0,dot(N,L)) * LightColor;   
    float3 V = normalize(eyes - pos);
#ifdef SPECULAR
	float spec = computerSpecLight(V,N,L,speculatPower);
	ret += spec * specularRate * specularColor * LightColor;
#endif
#ifdef SSS
	ret += ComputeSSSLight(-L,N,V ,SSSRate * 10 * length(LightColor),LightColor);
#endif
#endif


    return ret;
}
#endif

#ifdef COVERMAP
float3 CalConverMap(float3 worldpos)
{
	float2 uv  = ConverUV(worldpos.x,worldpos.z);
	float4 convermap = tex2D(SamplerConver , uv);
    	//float4 col1 = lerp(1,convermap*1.5,convermap.a); 
	float4 converColor = convermap * 1.5f;
	return converColor;
}
#endif

float3 ComputeLight(
	MaterialPixelParameters In
#ifdef SPECULAR
	,float3 specularColor,
	float specularPower,//15
	float specularRate//0.5
#endif
#ifdef SSS
	,float sssRate
#endif
#ifdef SHADOWMAP
	,float shadowMask
#endif
#if defined(POINTLIGHT) || defined(COVERPOINTLIGHT)
	,float4 screenSpace
	,bool bPointLight
 #endif
	)
{
	float Light    = max(0, dot(In.WorldNormal, -sunLight.m_dir));
	float comLight = max(0, dot(In.WorldNormal, sunLight.m_dir));
	float skyLight = max(0, dot(In.WorldNormal, -sky_light_dir));
	//calculate sunlight diffuse etc.
	float3 color = Light * sunLight.m_diffuse.rgb + comLight * sunLight.m_com_light.rgb + skyLight * sunLight.m_sky_light.rgb;
#ifdef SPECULAR  //calculate sunlight specular
	float3 V = eyes - In.WorldPosition;
    float spec = computerSpecLight(V,In.WorldNormal,-sunLight.m_dir,specularPower);
	color += spec * sunLight.m_specular * specularColor * specularRate * Light;
#endif
#ifdef SHADOWMAP
	color *= shadowMask;
#endif
	color += sunLight.m_sceneAmbient.rgb;


#if defined(POINTLIGHT) || defined(COVERPOINTLIGHT)
	color += CalPointLight(
				In.WorldNormal,
				In.WorldPosition,
				screenSpace,
				bPointLight
#ifdef SPECULAR
				,specularColor,
				specularPower,
				specularRate
#endif
#ifdef SSS
				,sssRate
#endif
				);
#endif
#ifdef COVERMAP
	color *= CalConverMap(In.WorldPosition);
#endif
	return 2*color;
}

#endif

