#include "CommonParams.h"
#include "UserShader.fx"

struct vertexInput
{
    float4 Position : POSITION0;
    float3 Normal    : NORMAL0;
    float4 Weights  : BLENDWEIGHT;
    float4 Indices  : BLENDINDICES;
#if NUM_USER_TEXCOORDS
    float2 TexCoords[NUM_USER_TEXCOORDS] : TEXCOORD0;
#endif
};

struct vertexOutput
{
    float4 outPosition      : POSITION;
    float4 Color          : COLOR0;
    float4 WorldPosition    : TEXCOORD0;
    float4 Normal           : TEXCOORD1; // Normal.w ... fog
    float4 ScreenPosition   : TEXCOORD2;
    float4 VertexPosition   : TEXCOORD3;
    float3 VertexNormal     : TEXCOORD4;
#if NUM_USER_TEXCOORDS
    float2 TexCoords[NUM_USER_TEXCOORDS] : TEXCOORD5;
#endif
};

MaterialVertexParameters GetMaterialVertexParameters(vertexInput Input)
{
    MaterialVertexParameters Params;
    Params.WorldPosition = Input.Position.xyz;
    return Params;
}

MaterialPixelParameters GetMaterialParameters(vertexOutput Input)
{
    MaterialPixelParameters Params;
#if NUM_USER_TEXCOORDS
    [unroll(NUM_USER_TEXCOORDS)]for (int i = 0; i < NUM_USER_TEXCOORDS; i++)
        Params.TexCoords[i] = Input.TexCoords[i];
#endif
    Params.WorldNormal = Input.Normal.xyz;//.w fog
    Params.ScreenPosition = Input.ScreenPosition;
    Params.WorldPosition = Input.WorldPosition.xyz;
    return Params;
}

vertexOutput VertexShaderPreview(vertexInput Input)
{
    vertexOutput Output = (vertexOutput)0;

    float4 position = Input.Position;
    Output.WorldPosition = mul(position, world);
    Output.ScreenPosition = mul(position, wvp);
    Output.outPosition = Output.ScreenPosition;
    Output.VertexPosition = Input.Position;
    Output.VertexNormal = Input.Normal.xyz;
    Output.Color = float4(1.0f, 1.0f, 1.0f, 1.0f);

#if NUM_USER_TEXCOORDS
    [unroll(NUM_USER_TEXCOORDS)]for (int i = 0; i < NUM_USER_TEXCOORDS; i++)
    Output.TexCoords[i] = Input.TexCoords[i];
#endif
    float3 normal = Input.Normal;
    if(!any(normal))
        normal=float3(0,1,0);
    Output.Normal.xyz = normal;
    Output.Normal.w   = CalFogFactor(Output.outPosition.z);
#if defined(LM_XXMESH) || defined(LM_XXPLAYER)
    Output.Normal.w   = CalFogFactor(Output.outPosition.z,Output.WorldPosition.y);
#endif

    return Output;
}

float4 PixelShaderPreview(vertexOutput Input) : COLOR0
{
    float4 retColor = 0;
    MaterialPixelParameters Params = GetMaterialParameters(Input);
	
    retColor.rgb = GetPreviewColor(Params);
    retColor.a = 1.0f;
    return retColor;
}

technique Preview
{
    pass p0
    {
        VertexShader = compile vs_3_0 VertexShaderPreview(); 
        PixelShader  = compile ps_3_0 PixelShaderPreview();
    
        CullMode = cw; 
        ZEnable = true; 
        ZWriteEnable = true;
    }
}