//defined by c++
#define NUM_USER_TEXCOORDS 1
#ifdef TERRAIN
	#if NUM_USER_TEXCOORDS < 2
	#define NUM_USER_TEXCOORDS 2
	#endif
#endif

//move from light.fx, for custom lighting
#ifdef POINTLIGHT
#define MaxPointLightNum 4
struct PointLightInfo
{
    int nPointLightCount;
    float4 PointLightPosition[MaxPointLightNum];
    float4 PointLightColor[MaxPointLightNum]; 
};
PointLightInfo pointLight;
#endif

struct MaterialVertexParameters
{
    float3 VertexPosition;
    float3 VertexNormal;
    float3 WorldPosition;
    float4 VertexColor;
};

struct MaterialPixelParameters
{
#if NUM_USER_TEXCOORDS
    float2 TexCoords[NUM_USER_TEXCOORDS];
#endif
    //float3 TangentNormal;    
    float3 WorldNormal;
    float3 WorldPosition; 
    float3 VertexPosition;
    float3 VertexNormal;
    float4 ScreenPosition;
    float4 VertexColor;
};

struct ParamsMainVertexNode
{
	float3 WorldPositionOffset;
};

struct ParamsMainPixelNode
{
	float3 Diffuse;
	float3 Normal;
	float3 Ambient;
	float3 Specular;
	float  SpecularPower;
	float3 Emissive;
	float  Opacity;
	float4 CustomLighting;
};

//PSм߿ռ
//#define NORMALMAP
#ifdef NORMALMAP
float3x3 ComputeTangentFrame(float3 N,float3 p,float2 uv)
{
	float3 dp1 = ddx(p);
	float3 dp2 = ddy(p);
	float2 duv1 = ddx(uv);
	float2 duv2 = ddy(uv);
	
	float3x3 M = float3x3(dp1,dp2,cross(dp1,dp2));
	float2x3 inversetransposeM = 
		float2x3(cross(M[1],M[2]),cross(M[2],M[0]));
	float3 T = mul(float2(duv1.x,duv2.x),inversetransposeM);
	float3 B = mul(float2(duv1.y,duv2.y),inversetransposeM);

	//float r = (dot(cross(T,B),N)<0.0f) ? -1.0f : 1.0f;
	return float3x3(normalize(T),normalize(B),N);
}

float4 CalcNormalfromTangentSpaceTexture(float4 normalTex,MaterialPixelParameters Parameters)
{
		float3 normal = normalize(2*normalTex.rgb -1);
		float3x3 TangentToLocal = ComputeTangentFrame(Parameters.WorldNormal,Parameters.WorldPosition,Parameters.TexCoords[0]);
		normal = mul(normal,TangentToLocal);
		float4 wnormal = float4(normal,1);
		return wnormal;
}

float4 CalcNormalfromLocalSpaceTexture(float4 normalTex)
{
		float3 normal = normalize(2*normalTex.rbg -1);
		normal = mul(normal,GetWorldMatrixforNormal());
		float4 wnormal = float4(normal,1);
		wnormal = normalize(wnormal);
		return wnormal;
}
#endif


void CalcMaterialNormalParams(in out MaterialPixelParameters Parameters, in out ParamsMainPixelNode MainPixelNode)
{
    float3 normal = MainPixelNode.Normal;
    if(!any(normal))
    {
    	normal = Parameters.WorldNormal;
    }
		Parameters.WorldNormal =  normalize(normal);
}

/** Rotates Position about the given axis by the given angle, in radians, and returns the offset to Position. */
float3 RotateAboutAxis(float4 NormalizedRotationAxisAndAngle, float3 PositionOnAxis, float3 Position)
{
	// Project Position onto the rotation axis and find the closest point on the axis to Position
	float3 ClosestPointOnAxis = PositionOnAxis + NormalizedRotationAxisAndAngle.xyz * dot(NormalizedRotationAxisAndAngle.xyz, Position - PositionOnAxis);
	// Construct orthogonal axes in the plane of the rotation
	float3 UAxis = Position - ClosestPointOnAxis;
	float3 VAxis = cross(NormalizedRotationAxisAndAngle.xyz, UAxis);
	float CosAngle;
	float SinAngle;
	sincos(NormalizedRotationAxisAndAngle.w, SinAngle, CosAngle);
	// Rotate using the orthogonal axes
	float3 R = UAxis * CosAngle + VAxis * SinAngle;
	// Reconstruct the rotated world space position
	float3 RotatedPosition = ClosestPointOnAxis + R;
	// Convert from position to a position offset
	return RotatedPosition - Position;
}

float2 Rotator(float2 Position,float2 Center,float Angle)
{
	Position=Position-Center;
	float2 rot=float2(cos(Angle),sin(Angle));
	float x=Position.x*rot.x-Position.y*rot.y+Center.x;
	float y=Position.x*rot.y+Position.y*rot.x+Center.y;
	return float2(x,y);
}

float3 Reflection(MaterialPixelParameters Parameters,float3 InputDir)
{
	float3 N = Parameters.WorldNormal;
	float3 I = normalize(InputDir);
	float3 Reflection = reflect(InputDir,N);
	return Reflection;
}

float Fresnel(MaterialPixelParameters Parameters,float3 Normal,float addend,float multiplier, float exponent)
{
	//saturate(A + B * pow(1 - dot(ViewDir,Normal),C));
	float3 V = normalize(eyes-Parameters.WorldPosition);
	float3 N = normalize(Normal);
	float x = abs(1-max(0,dot(V,N)));
	x = x < 0.0001f ? 0 : pow(x, exponent);
	float result = addend + multiplier * x;
	return result;
}

float Random(float2 seed)
{
	float2 r = float2(23.1406926327792690,  // e^pi (Gelfond's constant)
			  2.6651441426902251); // 2^sqrt(2) (GelfondCSchneider constant)
	return frac( cos( fmod( 123456789., 1e-7 + 256. * dot(seed,r) ) ) );  
}

 // * UnMirrored == 1 if normal
 // * UnMirrored == -1 if mirrored ,how to know?
float UnMirror(float Coordinate,float UnMirrored )
{
	return ((Coordinate)*(UnMirrored)*0.5+0.5);
}

float2 CalculateTextureCoordinate(float2 UV,float Utiling,float Vtiling,bool UnMirroredU,bool UnMirroredV)
{
	float2 Coordinates = float2(UV.x * Utiling , UV.y * Vtiling);
	if(UnMirroredU)
		Coordinates.x = UnMirror(Coordinates.x, 1);
	if(UnMirroredV)
		Coordinates.y = UnMirror(Coordinates.y, 1);
	return Coordinates;
}

float4 GetTexColorThreeSample(sampler2D SamplerTex, float3 wsCoord,float3 vNormal)
{
    wsCoord.y = 1 - wsCoord.y; 

    float2 coord1 = wsCoord.zy;
    float2 coord2 = wsCoord.zx;
    float2 coord3 = wsCoord.xy;
   
    float4 col1 = tex2D(SamplerTex,coord1);
    float4 col2 = tex2D(SamplerTex,coord2);
    float4 col3 = tex2D(SamplerTex,coord3);
   
    float4 OutColor = col1.xyzw * vNormal.x + 
                      col2.xyzw * vNormal.y + 
                      col3.xyzw * vNormal.z;
    return OutColor;                                        
}